<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Coming Soon - Iso Pro Audit App</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .navbar-toggler.toggled .navbar-toggler-icon::before {
            content: 'X'; /* Unicode for the correct 'X' symbol */
            font-size: 1.5rem;
        }
        .navbar-toggler-icon {
            transition: transform 0.3s ease;
        }
        .navbar-toggler.collapsed .navbar-toggler-icon::before {
            content: 'X';
            font-size: 1.5rem;
        }
        .navbar-toggler-icon {
            transition: transform 0.3s ease;
        }
        body {
            margin: 0;
            background-color: #f0f0f0;
        }
        .main-content {
            padding-top: 56px; /* Adjust height to exclude navbar height */
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .content-wrapper {
            width: 80%;
            max-width: 1200px;
        }
        .row {
            display: flex;
            align-items: flex-start;
        }
        .content-wrapper img {
            max-width: 100%;
            height: auto;
        }
        .btn-custom {
            margin-top: 20px;
        }
        @media (max-width: 767px) {
            .content {
                text-align: center;
                margin-top: 20px;
            }
            .get-notified-wrapper {
                display: flex;
                justify-content: center;
                margin-top: 20px;
            }
        }
        }
    </style>
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <div class="container">
            <a class="navbar-brand" href="#">My ISO Pro</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#registerModal">Register</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#loginModal">Login</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <div class="main-content">
        <div class="content-wrapper">
            <div class="row">
                <div class="col-md-6">
                    <img src="iso.webp" alt="Iso Pro Audit App Image" class="img-fluid">
                </div>
                <div class="col-md-6 content d-flex flex-column justify-content-start">
                    <h1>Coming Soon: Iso Pro Audit App</h1>
                    <p>For more info call Phillip Randazzo at <a href="tel:+12148403136">214-840-3136</a></p>
                    <div class="card mt-4 get-notified-wrapper">
                        <div class="card-body">
                            <p>If you would like to be updated on our progress and notified when the site goes live, give us your contact info to get notified.</p>
                            <button type="button" class="btn btn-info btn-custom mt-3 w-100" data-bs-toggle="modal" data-bs-target="#notifyModal">Get Notified</button>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Notify Modal -->
    <div class="modal fade" id="notifyModal" tabindex="-1" aria-labelledby="notifyModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="notifyModalLabel">Get Notified</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>If you would like to be updated on our progress and notified when the site goes live, please fill out the form below:</p>
                    <form class="mt-3">
                        <div class="mb-3">
                            <label for="companyName" class="form-label">Company Name</label>
                            <input type="text" class="form-control" id="companyName" placeholder="Enter your company name">
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email address</label>
                            <input type="email" class="form-control" id="email" placeholder="Enter your email">
                        </div>
                        <div class="form-check mb-3">
                            <input type="checkbox" class="form-check-input" id="betaTester">
                            <label class="form-check-label" for="betaTester">I would like to be a beta tester</label>
                        </div>
                        <button type="submit" class="btn btn-info btn-custom w-100">Notify Me</button>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const navbarToggler = document.querySelector('.navbar-toggler');
            const navbarNav = document.getElementById('navbarNav');
            navbarToggler.addEventListener('click', function () {
                const isExpanded = this.getAttribute('aria-expanded') === 'true';
                this.setAttribute('aria-expanded', !isExpanded);
                this.classList.toggle('toggled');
                navbarNav.classList.toggle('show');
            });
        });
    </script>
<!-- Fullscreen Registration Modal -->
<div class="modal fade fullscreen-modal" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="registerModalLabel">Register</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container">
                    <h2 class="text-center">Customer Registration</h2>
                    <form action="registration_process.php" method="POST">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="firstName" class="form-label"><strong>First Name</strong></label>
                                    <input type="text" class="form-control" id="firstName" name="first_name" required>
                                </div>
                                <div class="mb-3">
                                    <label for="lastName" class="form-label"><strong>Last Name</strong></label>
                                    <input type="text" class="form-control" id="lastName" name="last_name" required>
                                </div>
                                <div class="mb-3">
                                    <label for="username" class="form-label"><strong>Username</strong></label>
                                    <input type="text" class="form-control" id="username" name="username" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label"><strong>Email</strong></label>
                                    <input type="email" class="form-control" id="email" name="email" required>
                                </div>
                                <div class="mb-3">
                                    <label for="phone" class="form-label"><strong>Phone</strong></label>
                                    <input type="text" class="form-control" id="phone" name="phone">
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="address" class="form-label"><strong>Address</strong></label>
                            <input type="text" class="form-control" id="address" name="address">
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="city" class="form-label"><strong>City</strong></label>
                                    <input type="text" class="form-control" id="city" name="city">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="state" class="form-label"><strong>State</strong></label>
                                    <input type="text" class="form-control" id="state" name="state">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="zip" class="form-label"><strong>ZIP Code</strong></label>
                                    <input type="text" class="form-control" id="zip" name="zip">
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="country" class="form-label"><strong>Country</strong></label>
                            <input type="text" class="form-control" id="country" name="country">
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Register</button>
                    </form>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Add this to your custom styles to make the modal fullscreen -->
<style>
    .modal.fullscreen-modal .modal-dialog {
        width: 100vw;
        height: 100vh;
        margin: 0;
        padding: 0;
        max-width: 100%;
    }
    .modal.fullscreen-modal .modal-content {
        height: 100%;
        border-radius: 0;
    }
</style>



    <!-- Bootstrap JS (Optional) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="loginModalLabel">Login</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="mb-3">
                            <label for="loginEmail" class="form-label">Email address</label>
                            <input type="email" class="form-control" id="loginEmail" placeholder="Enter your email">
                        </div>
                        <div class="mb-3">
                            <label for="loginPassword" class="form-label">Password</label>
                            <input type="password" class="form-control" id="loginPassword" placeholder="Enter your password">
                        </div>
                        <button type="submit" class="btn btn-primary">Login</button>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
